﻿<%@ Page Title="Surveys" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="Surveys.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.Surveys" %>

<%@ Register Assembly = "AjaxControlToolkit" TagPrefix = "cc1" Namespace = "AjaxControlToolkit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
    
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID = "MainContent" Runat="Server" >
   
    <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();

        });
    </script>

    
   <div class = "excludeSaveWarnings">
   <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Filter by Last Name:</asp:Label>
                            
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Click"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick = "ButtonClear_Click" 
            />
        <br /><br />
    </div>   
    <asp:GridView ID = "GridViewEFRSurveys" runat = "server" 
        AutoGenerateColumns = "false" OnRowCommand = "Surveys_RowCommand" 
        AllowPaging="True" PageSize="20" DataKeyNames = "SurveyId" 
        OnRowDataBound = "Surveys_RowDataBound" AllowSorting="true" 
        onpageindexchanging="Surveys_PageIndexChanging" 
        onselectedindexchanging="Surveys_SelectedIndexChanging" 
        onsorting="Surveys_Sorting"
        CssClass="gridRegistry" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty">
       <EmptyDataTemplate>
            No questionnaires exist in this status
       </EmptyDataTemplate> 
        
        <Columns>        
            <asp:TemplateField HeaderText = "Workflow ID" SortExpression = "CaseId" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelCaseID" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("CaseId"))) %>' ></asp:Label> 
                
                </ItemTemplate> 
            </asp:TemplateField>
            <asp:TemplateField HeaderText = "Questionnaire/Form Number" SortExpression = "SurveyId" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelReferralID" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("SurveyId"))) %>' ></asp:Label> 
                
                </ItemTemplate> 
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Patient Name" SortExpression = "PatientName">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientName"))) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Site Number" SortExpression = "StationNumber">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelStation" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("StationNumber"))) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField> 
            <asp:TemplateField HeaderText="Facility" SortExpression = "Institution">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelInstitution" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("Institution"))) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>                      
            <asp:TemplateField HeaderText="Received Date" SortExpression = "ReceivedDate">
                    
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelSurveyReceivedDate" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ReceivedDate"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
                       
            <asp:TemplateField HeaderText="Version" SortExpression="Version">
                    
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelSurveyVersion" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("Version"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
                       
           <asp:TemplateField HeaderText="Status">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelSurveyStatus" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("SurveyStatus"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Type" SortExpression = "SurveyType">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelSurveyType" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("SurveyType"))) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details"  AccessibleHeaderText = "Select"  />
            <asp:TemplateField ItemStyle-Width = "50px">
                <ItemTemplate>
                    <asp:Button ID = "buttonReport" runat = "server" Text = "View" CommandArgument = '<%# Container.DataItemIndex %>' CommandName = "ViewReport" /> 
               </ItemTemplate> 
            
            </asp:TemplateField>
        </Columns>
    </asp:GridView>            
    
    
    <asp:Label SkinID="DataLabel" ID="lblPopupTargetID" runat="server" Style="display:none;"></asp:Label>

    <asp:Panel ID="pnlModalPanel" runat="server" >    
    <table border="1"> 
        <tr>        
            <td align="left">                 
                <asp:Label SkinID="DataLabel" ID = "LabelReport" runat = "server"></asp:Label>      
            </td> 
                    
            
        </tr>
        
        <tr>
            <td align = "center"> 
                <br />
                <br />      
                
            </td>        
        </tr> 
    
    </table> 
    </asp:Panel>
    
    <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />  
                    
</asp:Content> 